﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using GameNetwork;

//	Summary
//		* 우편함의 우편물 cell item

/*
	Post item
 */
public class PostItem : MonoBehaviour {

	public delegate void onPostItemEvent(PostItem item);
	public event onPostItemEvent onPostItem;
	public Image ItemImage;
	public Text ItemAmount;
	public Text ItemMessage;
	public Text ReceiveDate;
	public Button ReceiveButton;

	public Sprite goldImage;
	public Sprite healthImage;
	public Sprite speedImage;
	public Sprite defaultImage;

	private Post _post;

	public Post post {
		get {
			return _post;
		}

		set {
			_post	= value;

			if (string.Equals("gold", _post.itemCode)) {
				ItemImage.sprite = goldImage;

			} else if (string.Equals("health", _post.itemCode)) {
				ItemImage.sprite = healthImage;

			} else if (string.Equals("speed", _post.itemCode)) {
				ItemImage.sprite = speedImage;

			} else {
				ItemImage.sprite = defaultImage;
			}

			ItemAmount.text = _post.itemAmount.ToString();
			ItemMessage.text = _post.userMessage;
			ReceiveDate.text = _post.date;
		}
	}

	void OnDestroy()
	{
		Debug.Log("Did remove PostItem.");
		
		onPostItem	= null;
	}

	public void RemoveMe()
	{
		if (onPostItem != null) {
			onPostItem(this);
		}

		Debug.Log("Will remove PostItem.");

		DestroyImmediate(this.gameObject);
	}
}
